from browser import document, window
from browser.timer import set_interval, clear_interval
import random


class DadoApp:

	states = {}
	interval = None
	times = 0

	def __init__(self, vista, boton):

		self.vista = vista
		self.boton = boton

		for i in range(1, 7):
			self.states[i] = f'assets/{i}.png'

		self.show_random()

		self.boton.bind('click', self.lanzar)

	def show_random(self):
		n = random.randrange(1, 7)
		self.vista.src = self.states[n]

	def lanzar(self, e):

		def show_timer():
			self.show_random()
			if self.times < 20:
				self.times += 1
			else:
				clear_interval(self.interval)
				window.navigator.vibrate(100)
				self.boton.disabled = False
				self.times = 0


		self.boton.disabled = True
		self.interval = set_interval(show_timer, 100)




if __name__ == '__main__':

	imgVista = document['vista-dado']
	btnLanzar = document['lanzar-dado']

	DadoApp(imgVista, btnLanzar)